set terminal postscript portrait enhanced color  "Times" 12
set autoscale                          # scale axes automatically
set xtic auto                          # set xtics automatically
set ytic auto                          # set ytics automatically
set palette defined ( 0 "#FF0000", 0.5 "#FF00FF", 1 "#0000FF", 1.5 "#00FFFF", 2 "#00FF00", 2.5 "#FFFF00" )
set cbrange [0:2.5]
set palette defined ( 0 "#FF0000", 1 "#FF00FF", 2 "#0000FF", 3 "#00FFFF", 4 "#00FF00", 5 "#FFFF00" )
set cbrange [0:5]

set xlabel "10Dq (eV)" font "Times,12"
set ylabel "Energy (eV)" font "Times,12" offset -3

set out 'EnergyLevelDiagram.ps'
set size 1.0, 0.625
set label "^{3}F_{4}" at  -0.3,-1.5111372797805 font "Times,14"
set label "^{3}F_{3}" at  -0.3,-1.3469544971644 font "Times,14"
set label "^{3}F_{2}" at  -0.3,-1.2348309108877 font "Times,14"
set label "^{1}D_{2}" at  -0.3,0.42501693238367 font "Times,14"
set label "^{3}P_{2}" at  -0.3,0.84908995809866 font "Times,14"
set label "^{1}G_{4}" at  -0.3,1.499251862547 font "Times,14"
set label "^{1}S_{0}" at  -0.3,5.7275795716207 font "Times,14"
plot for [i=2:90:2] "EnergyLevelDiagram" using 1:i:i+1 notitle with lines lc palette z
